import './index.scss';
import cn from 'classnames';

import { TextOverImage as ITextOverImage } from './model/interface';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';
import AspectRatio from '@/shared/ui/AspectRatio/index';
import { DATA_SECTION_TITLE } from '@/app/lib/constants';

const TextOverImage = ({
  title,
  description,
  type,
  desktopType,
  img,
  sectionId,
  internalSectionTitle,
}: ITextOverImage) => {
  return (
    <section
      id={sectionId}
      className={cn('text-over-image', {
        'text-over-image_centered': type === 'centered',
        'text-over-image_desktop-left': desktopType === 'left',
        'text-over-image_desktop-centered': desktopType === 'centered',
      })}
      {...(internalSectionTitle
        ? { [DATA_SECTION_TITLE]: internalSectionTitle }
        : {})}
    >
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="text-over-image__text">
              <div>
                <h2 className="text-over-image__title typo-head-3">{title}</h2>
              </div>
              <p className="text-over-image__description typo-head-3">
                {description}
              </p>
            </div>
          </div>
        </div>
      </div>
      {img && (
        <div className="text-over-image__image-container">
          <AspectRatio
            width={img.width}
            height={img.height}
            className="text-over-image__image"
          >
            <StrapiImage img={img} />
          </AspectRatio>
        </div>
      )}
    </section>
  );
};

export default TextOverImage;
