'use client';

import { Swiper, SwiperSlide } from 'swiper/react';
import 'swiper/css';

import './index.scss';
import { TestimonialSlider } from '../../model/interface';
import Testimonial from '../Card/index';

const Slider = ({ className, slides }: TestimonialSlider) => {
  return slides.length > 1 ? (
    <Swiper className={className} spaceBetween={16} slidesPerView={'auto'}>
      {slides.map((testimonial, index) => (
        <SwiperSlide
          className="testimonials-slider__slide"
          key={testimonial.description + index}
        >
          <Testimonial {...testimonial} />
        </SwiperSlide>
      ))}
    </Swiper>
  ) : (
    <div className={className}>
      <Testimonial {...slides[0]} />
    </div>
  );
};

export default Slider;
