import { StrapiImage } from '@/shared/ui/StrapiImage/index';
import { TestimonialCard } from '../../model/interface';
import './index.scss';

const Testimonial = (testimonial: TestimonialCard) => {
  return (
    <div className="testimonial-card">
      <div className="testimonial-card__container">
        <div className="testimonial-card__header">
          <div className="testimonial-card__img">
            <StrapiImage alt={testimonial.name} img={testimonial.img} />
          </div>
          <div className="testimonial-card__info">
            <span className="testimonial-card__name typo-body-1-h">
              {testimonial.name}
            </span>
            <div className="testimonial-card__details">
              <span className="testimonial-card__position">
                {testimonial.position}
              </span>
              <div className="testimonial-card__rate">
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="12"
                  height="12"
                  viewBox="0 0 12 12"
                  fill="none"
                  className="testimonial-card__rate-icon"
                >
                  <path
                    d="M6 9.51965L2.4735 11.4936L3.261 7.52965L0.293503 4.78565L4.307 4.30965L6 0.639648L7.693 4.30965L11.7065 4.78565L8.739 7.52965L9.5265 11.4936L6 9.51965Z"
                    fill="#949494"
                  />
                </svg>
                <span className="testimonial-card__value">
                  {testimonial.rate}/5
                </span>
              </div>
            </div>
          </div>
        </div>
        <p className="testimonial-card__description">
          {testimonial.description}
        </p>
      </div>
    </div>
  );
};

export default Testimonial;
