import RichText from '@/shared/ui/RichText';
import './index.scss';
import { Testimonials as ITestimonials } from './model/interface';
import Slider from './ui/Slider/index';

const Testimonials = ({ caption, title, slides, sectionId }: ITestimonials) => {
  return (
    <section className="testimonials" id={sectionId}>
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="testimonials__container">
              <span className="testimonials__caption typo-eyebrow">
                {caption}
              </span>
              <div className="testimonials__title">
                {title && <RichText text={title} />}
              </div>
              <Slider className="testimonials__slider" slides={slides} />
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default Testimonials;
