import { StrapiImage } from '@/shared/ui/StrapiImage/index';

import { ITechnicalInfo } from './model/interface';

import './index.scss';

import TechnicalInfoItem from './ui/TechnicalInfoItem';
import RichText from '@/shared/ui/RichText';
import { DATA_SECTION_TITLE } from '@/app/lib/constants';

const TechnicalInfo = ({
  title,
  description,
  img,
  items,
  sectionId,
  internalSectionTitle,
}: ITechnicalInfo) => {
  return (
    <section
      className="technical-info"
      id={sectionId}
      {...(internalSectionTitle
        ? { [DATA_SECTION_TITLE]: internalSectionTitle }
        : {})}
    >
      <div className="container technical-info__container">
        <div className="row">
          <div className="col-12">
            <div className="technical-info__text">
              {title && (
                <div className="technical-info__title">
                  <RichText text={title} />
                </div>
              )}

              {description && (
                <p className="technical-info__description typo-head-3">
                  {description}
                </p>
              )}
            </div>
          </div>
        </div>
        <div className="row">
          <div className="col-12">
            <div className="technical-info__content">
              <div className="technical-info__items">
                {items.map((item, index) => (
                  <TechnicalInfoItem
                    key={index}
                    name={item.name}
                    value={item.value}
                  />
                ))}
              </div>
              <div className="technical-info__image-container">
                <StrapiImage img={img} className="technical-info__image" />
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default TechnicalInfo;
