'use client';

import {
  EVENTS,
  SEND_FORMDATA_ENDPOINT,
  SEND_FORMDATA_HEADERS,
} from '@/app/lib/constants';
import { CUSTOMER_ID } from '@/app/constants/common';
import { getStrapiURL } from '@/app/lib/utils';
import {
  useCallback,
  useEffect,
  useLayoutEffect,
  useRef,
  useState,
} from 'react';
import Form from '../Form';
import { useSearchParams } from 'next/navigation';
import externalApiOffer from '@/app/lib/externalApiOffer';
import { formatPhoneNumber } from '@/app/lib/format-phone-number';
import { sendTrackingEvent } from '@/app/lib/send-tracking-event';
import { useParams } from 'next/navigation';

const TRACKING_FORMS = [
  'offer-form',
  'offer-form-with-models',
  'single-offer-form',
  'single-offer-form-with-models',
];

const Steps = ({
  data,
  modalClose,
  initFormValues,
  hiddenFormFields,
  privacyModal,
  scrollToFormInMobile,
  downloadUrl,
}: any) => {
  const params = useParams();
  const searchParams = useSearchParams();
  const [activeStep, setActiveStep] = useState(0);
  const [stepsValues, setStepsValues] = useState({});
  const [steps, setSteps] = useState(null);
  const [requestWasSent, setRequestWasSent] = useState(false);

  const { stepsInputs, inputs, errors, uid } = data;

  const updateValues = ({ index, text }: any) => {
    setStepsValues((prev) => ({
      ...prev,
      [index]: {
        //@ts-ignore
        ...prev[index],
        [text]: initFormValues[text],
      },
    }));
  };

  useEffect(() => {
    setSteps(
      stepsInputs.reduce((acc: any, item: any, index: number) => {
        const { names, title, description } = item;

        return [
          ...acc,
          {
            ...item,
            title: initFormValues?.title || title,
            description: initFormValues?.description || description,
            errors,
            inputs: names.reduce((acc: any, { text }: any) => {
              const input = inputs.find(({ name }: any) => text === name);
              if (input) {
                if (initFormValues?.[text]) {
                  updateValues({ index, text });
                }
                return [...acc, input];
              } else {
                return acc;
              }
            }, []),
          },
        ];
      }, []),
    );
  }, []);

  const handleStepSubmit = async (data: any) => {
    if (requestWasSent) return;
    const stepsData = { ...stepsValues, [activeStep]: data };
    setStepsValues(stepsData);
    const submit = (steps![activeStep] as any).submit || {};
    let endpoint = submit?.endpoint;
    const nextStep = activeStep + 1;
    const stepsSize = (steps as any).length - 1;

    const promise = new Promise<any>(async (resolve) => {
      let trackerData = {};
      let reqData = {
        ...(submit?.hiddenFields || {}),
        ...(hiddenFormFields || {}),
      };

      if ((steps![activeStep] as any).submit.names.length) {
        (steps![activeStep] as any).submit.names.forEach(({ text }: any) => {
          //@ts-ignore
          reqData[text] = data[text] || hiddenFormFields[text] || '';
        });
      } else {
        //@ts-ignore
        reqData = Object.values(stepsData || {}).reduce(
          (acc: any, step: any) => {
            return { ...acc, ...step };
          },
          reqData,
        );
      }

      trackerData = reqData;

      if (endpoint) {
        setRequestWasSent(true);

        const isStrapiEndpoint = endpoint.startsWith(getStrapiURL());

        if (endpoint.includes('/saveoffer.php')) {
          const sourceValue = searchParams?.get('source');

          if (!!sourceValue) {
            reqData['source'] = sourceValue;
          }
        }

        // TODO: Clear up phone formatting rules and implement proper phone localization
        if (
          (endpoint.includes('/savewebsite.php') ||
            endpoint.includes('/saveoffer.php')) &&
          'mobile' in reqData &&
          reqData.mobile?.length === 9
        ) {
          reqData.mobile = `0${reqData.mobile}`;
        }

        const modifiedData = reqData;
        trackerData = reqData;
        // TODO: Refactor this
        if (
          endpoint.includes('/savewebsite.php') ||
          endpoint.includes('/saveoffer.php')
        ) {
          endpoint = `${endpoint}?${new URLSearchParams(reqData).toString()}`;
          reqData = {};
        }

        const shouldBeFormData = Object.values(reqData).find(
          //@ts-ignore
          (el: any) => el instanceof File,
        );

        let response: Response;
        if (shouldBeFormData) {
          const formData = new FormData();
          const data: any = {};

          Object.keys(reqData)
            .filter((key) => typeof reqData[key] !== 'undefined')
            .forEach((key) => {
              if (reqData[key] instanceof File) {
                const file = reqData[key];
                formData.append(`files.${key}`, file, file.name);
              } else {
                data[key] = reqData[key];
              }
            });

          formData.append('data', JSON.stringify(data));

          if (isStrapiEndpoint) {
            formData.append(
              SEND_FORMDATA_HEADERS,
              JSON.stringify({
                Authorization: `Bearer ${process.env.NEXT_PUBLIC_STRAPI_API_TOKEN}`,
              }),
            );
          }

          formData.append(SEND_FORMDATA_ENDPOINT, endpoint);

          response = await fetch('/api/send-form-with-file', {
            method: 'POST',
            body: formData,
          });
        } else {
          const sendForm = async (endpoint: string) => {
            response = await fetch('/api/send-form', {
              method: 'POST',
              headers: {
                'Content-Type': 'application/json',
              },
              body: JSON.stringify(
                isStrapiEndpoint
                  ? {
                      headers: {
                        'Content-Type': 'application/json',
                        Authorization: `Bearer ${process.env.NEXT_PUBLIC_STRAPI_API_TOKEN}`,
                      },
                      url: endpoint,
                      data: { data: reqData },
                    }
                  : {
                      headers: {
                        'Content-Type': 'application/json',
                      },
                      url: endpoint,
                      data: reqData,
                    },
              ),
            });

            return response;
          };

          const endpoint1 = endpoint
            .replace(
              'http://dashboard.cheryksa.com',
              'http://dashboard.cherybysanabel.com',
            )
            .replace(
              'https://dashboard.cheryksa.com',
              'http://dashboard.cherybysanabel.com',
            );

          const endpoint2 = endpoint.replace(
            'https://dashboard.cheryksa.com',
            'http://dashboard.cherybysanabel.com',
          );
          try {
            response = await sendForm(endpoint1);
            const data = await response.json();

            if (data?.message?.includes('error')) {
              console.log('Error in endpoint 1');
              throw new Error();
            }
          } catch (error) {
            console.log('Error', error);
            response = await sendForm(endpoint2);
          }
        }

        if (nextStep === stepsSize) {
          if (TRACKING_FORMS.includes(uid)) {
            try {
              //CDP API Integration
              await fetch('/api/send-form', {
                method: 'POST',
                headers: {
                  'Content-Type': 'application/json',
                },
                body: JSON.stringify(
                  externalApiOffer({
                    reqData: {
                      ...modifiedData,
                      unique_identifier: localStorage.getItem(CUSTOMER_ID),
                    },
                    searchParams,
                    lang: params!.lang as string,
                  }),
                ),
              });
            } catch (e) {
              console.log(e);
            }
          }
        }

        if (!isStrapiEndpoint) {
          // console.log({ 'API response': await response.json() });
        }
      }

      resolve(trackerData);
    });

    promise.then((data) => {
      setRequestWasSent(false);
      if (nextStep === stepsSize) {
        if (uid === 'subscribe-form') {
          sendTrackingEvent([
            EVENTS.TAG,
            'newsletter_signup',
            {
              ...data,
            },
          ]);
          sendTrackingEvent([EVENTS.GO]);
        }

        if (TRACKING_FORMS.includes(uid)) {
          sendTrackingEvent([
            EVENTS.TAG,
            'lead_form_submit',
            {
              ...data,
            },
          ]);
          sendTrackingEvent([EVENTS.GO]);
        }

        if (uid === 'test-drive') {
          sendTrackingEvent([
            EVENTS.TAG,
            'test_drive_form_submit',
            {
              ...data,
            },
          ]);
          sendTrackingEvent([EVENTS.GO]);
        }

        if (['event-form', 'event-form-with-models'].includes(uid)) {
          sendTrackingEvent([
            EVENTS.TAG,
            'event_form_submit',
            {
              ...data,
            },
          ]);
          sendTrackingEvent([EVENTS.GO]);
        }
      } else {
        if (['offer-form', 'offer-form-with-models'].includes(uid)) {
          sendTrackingEvent([
            EVENTS.TAG,
            'lead_form_partial_completion',
            {
              ...data,
            },
          ]);
          sendTrackingEvent([EVENTS.GO]);
        }
      }

      if (activeStep === (steps as any).length - 1) {
        modalClose();
        beforeClosingModal();
        console.log(stepsData);
      }

      if (nextStep <= stepsSize) {
        setActiveStep(nextStep);
      }
    });
  };

  const beforeClosingModal = () => {
    if (downloadUrl) {
      setTimeout(() => {
        window.open(downloadUrl, '_blank');
      }, 0);
    }
  };

  const handleSuccessClick = () => {
    if (activeStep === (steps as any).length - 1) {
      modalClose();
      beforeClosingModal();
    } else {
      setActiveStep(activeStep + 1);
    }
  };

  const handleBackButton = useCallback(() => {
    if (activeStep !== 0) {
      setActiveStep(activeStep - 1);
    }
  }, [activeStep]);

  const [formRef, setFormRef] = useState<HTMLDivElement | null>(null);

  useLayoutEffect(() => {
    if (formRef && scrollToFormInMobile && window.innerWidth < 1024) {
      formRef.scrollIntoView({ block: 'start', behavior: 'smooth' });
    }
  }, [formRef]);

  return (
    steps && (
      <div
        ref={(el) => {
          setFormRef(el);
        }}
        style={{
          display: 'flex',
          height: '100%',
          flexGrow: '1',
          flexDirection: 'column',
        }}
      >
        <Form
          key={activeStep}
          step={true}
          data={steps[activeStep]}
          onBackButton={handleBackButton}
          onNextButton={handleStepSubmit}
          onSuccessButtonClick={handleSuccessClick}
          //@ts-ignore
          values={stepsValues[activeStep]}
          privacyModal={privacyModal}
        />
      </div>
    )
  );
};

export default Steps;
