import './index.scss';
import Link from 'next/link';
import { ModelsList as IModelsList } from '../../model/interface';
import AspectRatio from '@/shared/ui/AspectRatio/index';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';

const ModelsList = ({ lang, models }: IModelsList) => {
  return (
    <div className="models-list">
      <div className="models-list__container">
        {models?.map(({ img, name, slug }) => (
          <div className="model" key={name}>
            <div className="model__container">
              <AspectRatio
                className="model__img"
                width={179}
                height={104}
                mobileWidth={123}
                mobileHeight={72}
              >
                <StrapiImage img={img} />
              </AspectRatio>

              <div className="model__content">
                <span className="model__name typo-head-5">{name}</span>
                <div className="model__links">
                  <Link
                    href={`/${lang}/models/${slug}`}
                    className="typo-link-2"
                  >
                    Discover
                  </Link>
                  <Link href={`/${lang}/order/${slug}`} className="typo-link-2">
                    Order
                  </Link>
                </div>
              </div>
            </div>
          </div>
        ))}
      </div>
    </div>
  );
};

export default ModelsList;
