import './index.scss';
import Link from 'next/link';
import { ArticlesList as IArticlesList } from '../../model/interface';
import AspectRatio from '@/shared/ui/AspectRatio/index';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';
import { Arrow } from '@/app/assets/icons';

const ArticlesList = ({ articles, translates }: IArticlesList) => {
  return (
    <div className="articles-list">
      <div className="articles-list__container">
        {articles?.map(({ data, title, description, url, img }) => (
          <Link href={url} className="article-card" key={url}>
            <div className="article-card__container">
              <div className="article-card__img">
                <AspectRatio
                  width={405}
                  height={200}
                  mobileWidth={72}
                  mobileHeight={72}
                >
                  <StrapiImage img={img} />
                </AspectRatio>
              </div>
              <div className="article-card__text">
                <span className="article-card__data typo-body-2">{data}</span>
                <span className="article-card__title typo-body-1-m">
                  {title}
                </span>
                <span className="article-card__description typo-body-2 d-lg-none-down">
                  {description}
                </span>
              </div>
              <div className="article-card__arrow">
                <span className="typo-link-big d-lg-none-down">
                  {translates?.readMore || 'Read more'}
                </span>
                <div className="article-card__arrow-icon">{Arrow}</div>
              </div>
            </div>
          </Link>
        ))}
      </div>
    </div>
  );
};

export default ArticlesList;
