import './index.scss';
import NextLink from 'next/link';
import AspectRatio from '@/shared/ui/AspectRatio';
import { StrapiImage } from '@/shared/ui/StrapiImage';
import SuggestedContent, {
  ISuggestedContent,
} from '@/shared/ui/SuggestedContent';

const RelatedContent = ({
  title,
  mainCard,
  cards,
  className = '',
}: {
  className?: string;
  title?: string;
  mainCard: ISuggestedContent;
  cards: ISuggestedContent[];
}) => {
  return (
    <section className={`related-content ${className}`}>
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="related-content__container">
              {title && <h2 className="related-content__title">{title}</h2>}
              <div className="related-content__cards">
                <NextLink href={mainCard.link} className="related-content-main">
                  <div className="related-content-main__container">
                    <AspectRatio
                      className="related-content-main__img"
                      width={811}
                      height={373}
                      mobileWidth={310}
                      mobileHeight={200}
                    >
                      <StrapiImage img={mainCard.img} />
                    </AspectRatio>
                    <div className="related-content-main__text">
                      <span className="related-content-main__title typo-head-3">
                        {mainCard.text}
                      </span>
                      <p className="related-content-main__description typo-body-1">
                        {mainCard.description}
                      </p>
                      <span className="related-content-main__data typo-body-2">
                        {mainCard.data}
                      </span>
                    </div>
                  </div>
                </NextLink>
                <div className="related-content__mini">
                  {cards?.map((card) => (
                    <SuggestedContent key={card.link} {...card} />
                  ))}
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default RelatedContent;
