import NextLink from 'next/link';
import cn from 'classnames';
import { OfferCard } from '../../model/interface';

import './index.scss';
import ArrowLink from '@/shared/ui/ArrowLink/index';
import AspectRatio from '@/shared/ui/AspectRatio/index';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';

const Card = ({
  type = 'md',
  img,
  mobileImg,
  data,
  title,
  description,
  url,
  readMoreText,
}: OfferCard) => {
  const isLargeCard = type === 'lg';

  return (
    <NextLink
      href={url}
      className={cn('offers-card', { 'offers-card_main': isLargeCard })}
    >
      <div className="offers-card__container">
        <div className="offers-card__img">
          <AspectRatio
            width={isLargeCard ? 775 : 600}
            height={isLargeCard ? 568 : 300}
            mobileWidth={310}
            mobileHeight={isLargeCard ? 310 : 176}
          >
            {img && (
              <StrapiImage
                img={img}
                className={cn({ 'd-lg-none-down': !!mobileImg })}
              />
            )}
            {mobileImg && (
              <StrapiImage
                alt={title}
                img={mobileImg}
                className="d-lg-none-up"
              />
            )}
          </AspectRatio>
        </div>
        <div className="offers-card__text">
          {data && (
            <span className="offers-card__data typo-eyebrow">{data}</span>
          )}
          {title && (
            <span
              className={`offers-card__title ${
                isLargeCard ? 'typo-head-3' : 'typo-head-4'
              }`}
            >
              {title}
            </span>
          )}
          {description && (
            <span className="offers-card__description typo-body-1">
              {description}
            </span>
          )}
          <ArrowLink
            likeTextWithArrow
            className="offers-card__link typo-link-big"
          >
            {readMoreText || 'Read more'}
          </ArrowLink>
        </div>
      </div>
    </NextLink>
  );
};

export default Card;
