import { StrapiImageInterface } from '@/shared/ui/StrapiImage/index';
import { RelatedFilterItem } from '@/widgets/RelatedContent/model/interface';

export interface OfferCard {
  type?: 'lg' | 'md';
  data?: string;
  title?: string;
  description?: string;
  url: string;
  img?: StrapiImageInterface;
  mobileImg?: StrapiImageInterface;
  readMoreText: string;
}

export interface PreviewOfferCard {
  title?: string;
  description?: string;
  img?: { data: { attributes: StrapiImageInterface } };
  mobileImg?: { data: { attributes: StrapiImageInterface } };
}

export interface CmsOfferCard {
  slug: string;
  updatedAt: string;
  previewData: PreviewOfferCard;
}

export interface Offers {
  showData?: boolean;
  filters?: RelatedFilterItem[];
  mainOffer: CmsOfferCard;
  translates: any;
  currentPage: number;
  totalPages: number;
  prefix: string;
  searchParams: any;
  cards: CmsOfferCard[];
  title: string;
  lang: string;
  internalSectionTitle?: string;
  emptyState: {
    title: string;
    returnUrl: string;
    buttonText: string;
  };
}
