import './index.scss';
import { Offers as IOffers } from './model/interface';
import { Card } from './ui';
import Pagination from '@/shared/ui/Pagination';
import Filter from '../News/ui/Filter';
import { formatTime } from '@/app/lib/utils';
import {
  CATEGORY_KEY,
  COUNTRY_KEY,
  DATA_SECTION_TITLE,
  SEARCH_KEY,
} from '@/app/lib/constants';
import cn from 'classnames';
import Button from '@/shared/ui/Button';
import React, { Fragment } from 'react';

const Offers = ({
  mainOffer,
  cards,
  title,
  filters,
  translates,
  currentPage,
  totalPages,
  prefix,
  searchParams,
  showData,
  emptyState,
  lang,
  internalSectionTitle,
}: IOffers) => {
  const hasContent = mainOffer || cards?.length;

  return (
    <div
      className={cn('offers', { offers_empty: !hasContent })}
      key={`${currentPage}${searchParams?.[CATEGORY_KEY]}${searchParams?.[COUNTRY_KEY]}${searchParams?.[SEARCH_KEY]}`}
    >
      <div className="container">
        <div className="row">
          <div className="col-12">
            {hasContent ? (
              <>
                <div className="offers__header">
                  <h1 className="offers__title typo-head-2">{title}</h1>
                  {!!filters?.length && (
                    <div className="offers__filter">
                      <Filter items={filters} />
                    </div>
                  )}
                </div>
                <div className="offers__container">
                  {mainOffer && (
                    <Card
                      key={mainOffer.slug}
                      type={'lg'}
                      data={
                        showData && mainOffer.updatedAt
                          ? formatTime(mainOffer.updatedAt)
                          : ''
                      }
                      title={mainOffer.previewData?.title}
                      description={mainOffer.previewData?.description}
                      url={`${prefix}/${mainOffer.slug}`}
                      img={mainOffer.previewData?.img?.data?.attributes}
                      mobileImg={
                        mainOffer.previewData?.mobileImg?.data?.attributes
                      }
                      readMoreText={translates?.getOffer || 'Get this offer'}
                    />
                  )}
                  {cards?.map(({ slug, previewData, updatedAt }, index) => {
                    const { description, title, img, mobileImg } =
                      previewData || {};

                    return (
                      <Fragment key={'tracker'}>
                        {(mainOffer ? index === 0 : index === 2) && (
                          <div
                            {...(internalSectionTitle
                              ? { [DATA_SECTION_TITLE]: internalSectionTitle }
                              : {})}
                            style={{
                              gridColumn: '1/ -1',
                            }}
                          ></div>
                        )}
                        <Card
                          key={slug}
                          title={title}
                          data={
                            showData && updatedAt ? formatTime(updatedAt) : ''
                          }
                          description={description}
                          url={`${prefix}/${slug}`}
                          img={img?.data?.attributes}
                          mobileImg={mobileImg?.data?.attributes}
                          readMoreText={
                            translates?.getOffer || 'Get this offer'
                          }
                        />
                      </Fragment>
                    );
                  })}
                </div>
                {totalPages > 1 && (
                  <div className="offers__pagination">
                    <Pagination
                      prefix={prefix}
                      currentPage={currentPage}
                      totalPages={totalPages}
                      searchParams={searchParams}
                    />
                  </div>
                )}
              </>
            ) : (
              <div className="offers__empty">
                <span className="typo-head-1 offer__empty-title">
                  {emptyState?.title || 'Currently, there are no content.'}
                </span>
                <Button
                  appearance="dark"
                  href={emptyState?.returnUrl || `/${lang}`}
                >
                  <span className="typo-link-big">
                    {emptyState?.buttonText || 'Return'}
                  </span>
                </Button>
              </div>
            )}
          </div>
        </div>
      </div>
    </div>
  );
};

export default Offers;
