import RichText from '@/shared/ui/RichText/index';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';
import './index.scss';
import { Banner } from './model/interface';
import cn from 'classnames';
import { getStrapiContent, getStrapiForm } from '@/app/lib/utils';
import Steps from '../Steps';
import { CSSProperties } from 'react';
import { PRIVACY_POLICY } from '@/app/lib/constants';

const MODEL_FIELD = 'model';

const OfferBanner = ({
  cmsName,
  data,
  title,
  description,
  img,
  mobileImg,
  lightColorInDesktop,
  caption,
  secondCaption,
  formUid,
  lang,
  defaultFormValues: formValuesFromCms,
  offeredModels,
  selectedProduct,
  imageBrightness,
}: Banner) => {
  const defaultFormValues = formValuesFromCms || {};

  const privacyContent = async () => {
    try {
      const privacyPage = await getStrapiContent({
        url: `/api/page/find-by-slug/${PRIVACY_POLICY}?locale=${lang}&populate=deep&publicationState=live`,
      });
      return privacyPage.data?.attributes?.content?.find(
        ({ __component }: any) => __component === 'general.text-content',
      )?.content;
    } catch (e) {
      return '';
    }
  };

  const renderForm = async () => {
    try {
      const form = await getStrapiForm({ formUid: formUid!, lang });

      if (form.data[0]) {
        const privacyText = await privacyContent();
        const modelField = form.data[0].attributes?.inputs.find(
          ({ __component, name }: any) =>
            __component === 'form.select' && name === MODEL_FIELD,
        );

        if (modelField) {
          if (offeredModels) {
            modelField.options = offeredModels;
          }

          if (selectedProduct) {
            const selectedValue = selectedProduct?.data?.attributes?.formValue;

            if (offeredModels) {
              if (offeredModels[selectedValue]) {
                defaultFormValues[MODEL_FIELD] = selectedValue;
              } else {
                if (!offeredModels[defaultFormValues?.[MODEL_FIELD]]) {
                  delete defaultFormValues[MODEL_FIELD];
                }
              }
            } else {
              if (modelField.options[selectedValue]) {
                defaultFormValues[MODEL_FIELD] = selectedValue;
              } else {
                if (!modelField.options[defaultFormValues[MODEL_FIELD]]) {
                  delete defaultFormValues[MODEL_FIELD];
                }
              }
            }
          } else {
            if (defaultFormValues?.[MODEL_FIELD]) {
              if (offeredModels) {
                if (!offeredModels[defaultFormValues[MODEL_FIELD]]) {
                  delete defaultFormValues[MODEL_FIELD];
                }
              } else {
                if (!modelField.options[defaultFormValues[MODEL_FIELD]]) {
                  delete defaultFormValues[MODEL_FIELD];
                }
              }
            }
          }
        }

        return (
          <Steps
            data={form.data[0].attributes}
            initFormValues={defaultFormValues}
            hiddenFormFields={{
              campaign: cmsName,
              [MODEL_FIELD]: selectedProduct?.data?.attributes?.formValue,
            }}
            privacyModal={{ linkTrigger: PRIVACY_POLICY, text: privacyText }}
            scrollToFormInMobile
          />
        );
      } else {
        return <></>;
      }
    } catch (e) {
      console.log(e);
    }

    return <></>;
  };

  return (
    <section
      className={cn('offer-banner', {
        'offer-banner_specific-form':
          formUid &&
          ['single-offer-form-with-models', 'single-offer-form'].includes(
            formUid,
          ),
      })}
    >
      <div className="offer-banner__main">
        <div className="container">
          <div className="row">
            <div className="col-12">
              <div className="offer-banner__container">
                <div
                  className={cn('offer-banner__content', {
                    'offer-banner__content_desktop-light': lightColorInDesktop,
                  })}
                >
                  <div className="offer-banner__content-container">
                    {data && <span className="typo-eyebrow">{data}</span>}
                    <h1>{title}</h1>
                    {description && (
                      <RichText
                        className="offer-banner__description"
                        text={description}
                        useMakeLinksExternal
                      />
                    )}
                  </div>
                </div>
                <div
                  className="offer-banner__img"
                  style={
                    imageBrightness
                      ? ({ '--brightness': imageBrightness } as CSSProperties)
                      : {}
                  }
                >
                  <StrapiImage
                    img={img}
                    className={cn({ 'd-lg-none-down': !!mobileImg })}
                  />
                  {mobileImg && (
                    <StrapiImage
                      alt={title}
                      img={mobileImg}
                      loading={'eager'}
                      className="d-lg-none-up"
                    />
                  )}
                </div>
                {formUid && (
                  <div className="offer-banner__form">
                    <div className="offer-banner__form-container">
                      {renderForm()}
                    </div>
                  </div>
                )}
              </div>
            </div>
          </div>
        </div>
      </div>

      {(caption || secondCaption) && (
        <div className="container offer-banner__caption">
          <div className="row">
            <div className="col-12">
              <div className="offer-banner__caption-container">
                {caption && (
                  <RichText
                    className="caption-container"
                    text={caption}
                    useMakeLinksExternal
                  />
                )}

                {secondCaption && (
                  <RichText
                    className="second-caption-container"
                    text={secondCaption}
                    useMakeLinksExternal
                  />
                )}
              </div>
            </div>
          </div>
        </div>
      )}
    </section>
  );
};

export default OfferBanner;
