import AspectRatio from '@/shared/ui/AspectRatio';
import Button from '@/shared/ui/Button';
import { StrapiImage, StrapiImageInterface } from '@/shared/ui/StrapiImage';
import './index.scss';

interface INotFound {
  title: string;
  description?: string;
  buttonText: string;
  img: StrapiImageInterface;
  lang: string;
}

const NotFound = ({ title, description, buttonText, img, lang }: INotFound) => {
  return (
    <section className="not-found">
      <div className="container">
        <div className="row">
          <div className="col-lg-4 col-12">
            <div className="not-found__text">
              <h1 className="not-found__title">{title}</h1>
              {description && (
                <span className="not-found__description typo-body-1-m">
                  {description}
                </span>
              )}
              <Button className="not-found__button" href={`/${lang}`}>
                {buttonText}
              </Button>
            </div>
          </div>
          <div className="col-lg-8 col-12">
            <div className="not-found__img">
              <AspectRatio
                width={954}
                height={501}
                mobileWidth={390}
                mobileHeight={205}
              >
                <StrapiImage img={img} />
              </AspectRatio>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default NotFound;
