'use client';
import { RelatedFilterItem } from '@/widgets/RelatedContent/model/interface';
import { useRouter, useSearchParams } from 'next/navigation';
import Select from '@/shared/ui/Select';
import SearchInput from '@/shared/ui/SearchInput';

const Filter = ({ items }: { items: RelatedFilterItem[] }) => {
  const searchParams = useSearchParams();
  const router = useRouter();

  const handleSearchNews = (name: string, value: string) => {
    const url = new URL(window.location.href);
    if (value) {
      url.searchParams.set(name, value);
    } else {
      url.searchParams.delete(name);
    }

    url.searchParams.delete('page');

    router.push(url.toString());
  };

  const renderFilterItem = ({
    name,
    type,
    options,
    placeholder,
  }: RelatedFilterItem) => {
    const valueFromQuery = searchParams?.get(name) || '';
    switch (type) {
      case 'select':
        let activeOption = options?.find(
          ({ value }) => valueFromQuery === value,
        );

        return (
          <Select
            key={name}
            name={name}
            placeholder={placeholder}
            value={activeOption}
            options={options!}
            onChange={(value: string) => {
              handleSearchNews(name, value);
            }}
          />
        );

      case 'search':
        return (
          <SearchInput
            key={name}
            name={name}
            placeholder={placeholder}
            value={valueFromQuery}
            onSearchClick={(value) => {
              handleSearchNews(name, value);
            }}
          />
        );

      default:
        return null;
    }
  };

  return <>{items.map(renderFilterItem)}</>;
};

export default Filter;
