import {
  CATEGORY_KEY,
  COUNTRY_KEY,
  DATA_SECTION_TITLE,
  SEARCH_KEY,
} from '@/app/lib/constants';
import { formatTime } from '@/app/lib/utils';
import Pagination from '@/shared/ui/Pagination';
import { Fragment } from 'react';
import { Card } from '../Offers/ui';
import { RelatedFilterItem } from '../RelatedContent/model/interface';
import './index.scss';
import Filter from './ui/Filter';

interface INews {
  title: string;
  articles: any;
  mainArticle: any;
  filters?: RelatedFilterItem[];
  translates: any;
  currentPage: number;
  totalPages: number;
  prefix: string;
  searchParams: any;
  internalSectionTitle?: string;
}

const News = ({
  title,
  mainArticle,
  articles,
  filters,
  translates,
  currentPage,
  totalPages,
  prefix,
  searchParams,
  internalSectionTitle,
}: INews) => {
  return (
    <div
      className="news"
      key={`${currentPage}${searchParams?.[CATEGORY_KEY]}${searchParams?.[COUNTRY_KEY]}${searchParams?.[SEARCH_KEY]}`}
    >
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="news__header">
              <h1 className="news__title typo-head-2">{title}</h1>
              {!!filters?.length && (
                <div className="news__filter">
                  <Filter items={filters} />
                </div>
              )}
            </div>
            <div className="news__container">
              {mainArticle && (
                <Card
                  key={mainArticle.slug}
                  type={'lg'}
                  data={formatTime(mainArticle.updatedAt)}
                  title={mainArticle.previewTitle}
                  description={mainArticle.previewDescription}
                  url={`${prefix}/${mainArticle.slug}`}
                  img={mainArticle.previewImg?.data?.attributes}
                  readMoreText={translates?.readMore || 'Read more'}
                />
              )}
              {articles?.map(
                (
                  {
                    previewImg,
                    slug,
                    previewDescription,
                    previewTitle,
                    updatedAt,
                  }: any,
                  index: number,
                ) => {
                  return (
                    <Fragment key={'tracker'}>
                      {(mainArticle ? index === 0 : index === 2) && (
                        <div
                          {...(internalSectionTitle
                            ? { [DATA_SECTION_TITLE]: internalSectionTitle }
                            : {})}
                          style={{
                            gridColumn: 'span 2 / span 2',
                            margin: '-8px 0',
                          }}
                        ></div>
                      )}
                      <Card
                        key={slug}
                        data={formatTime(updatedAt)}
                        title={previewTitle}
                        description={previewDescription}
                        url={`${prefix}/${slug}`}
                        img={previewImg?.data?.attributes}
                        readMoreText={translates?.readMore || 'Read more'}
                      />
                    </Fragment>
                  );
                },
              )}
            </div>
            {totalPages > 1 && (
              <div className="news__pagination">
                <Pagination
                  prefix={prefix}
                  currentPage={currentPage}
                  totalPages={totalPages}
                  searchParams={searchParams}
                />
              </div>
            )}
          </div>
        </div>
      </div>
    </div>
  );
};

export default News;
