'use client';

import { useState, useEffect } from 'react';

import cn from 'classnames';
import Link from 'next/link';

import { IModelsHeaderNavItem } from '../../model/interface';

const Navigation = ({ navigation }: { navigation: IModelsHeaderNavItem[] }) => {
  const [activeItem, setActiveItem] = useState<string>('');

  useEffect(() => {
    const sections = document.querySelectorAll('section');

    function onScroll() {
      sections.forEach((section) => {
        const sectionTop = section.offsetTop;

        if (window.scrollY >= sectionTop - 100) {
          setActiveItem(section.getAttribute('id')!);
        }
      });
    }
    onScroll();

    window.addEventListener('scroll', onScroll);

    return () => {
      window.removeEventListener('scroll', onScroll);
    };
  }, [navigation]);

  return (
    <div className="models-header__navigation">
      {navigation?.map((item, index) => (
        <Link
          className={cn('typo-link-2', 'models-header__navigation-item', {
            'models-header__navigation-item_active':
              `#${activeItem}` === item.href,
          })}
          key={index}
          href={item.href}
        >
          {item.label}
        </Link>
      ))}
    </div>
  );
};

export default Navigation;
