import { ModelsHeader as IModelsHeader } from './model/interface';

import './index.scss';
import StrapiButton from '@/shared/ui/StrapiButton';
import Navigation from './ui/Navigation';

const ModelsHeader = ({ lang, title, navigation, buttons }: IModelsHeader) => {
  return (
    <div className="models-header">
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="models-header__content">
              <span className="typo-body-2 models-header__title">{title}</span>
              <div className="models-header__buttons">
                {buttons?.map((button, index) => (
                  <StrapiButton key={index} button={button} lang={lang} />
                ))}
              </div>
            </div>

            {navigation && <Navigation navigation={navigation} />}
          </div>
        </div>
      </div>
    </div>
  );
};

export default ModelsHeader;
