'use client';
import { EVENTS } from '@/app/lib/constants';
import { sendTrackingEvent } from '@/app/lib/send-tracking-event';
import useClickOutside from '@/app/lib/use-outside-click';
import AspectRatio from '@/shared/ui/AspectRatio';
import { useState, cloneElement, useEffect, useRef } from 'react';
import ReactPlayer from 'react-player';
import './index.scss';

const VideoPlayer = ({
  videoTitle,
  url,
  trigger,
}: {
  videoTitle: string;
  url: string;
  trigger: any;
}) => {
  const [open, setOpen] = useState(false);
  const containerRef = useRef(null);

  useEffect(() => {
    ['html', 'body'].forEach((selector) => {
      const item = document.querySelector(selector) as HTMLElement;

      if (item) {
        if (open) {
          item.style.overflow = 'hidden';
          item.style.touchAction = 'none';
        } else {
          item.style.removeProperty('overflow');
          item.style.removeProperty('touch-action');
        }
      }
    });

    return () => {
      ['html', 'body'].forEach((selector) => {
        const item = document.querySelector(selector) as HTMLElement;

        if (item) {
          item.style.removeProperty('overflow');
          item.style.removeProperty('touch-action');
        }
      });
    };
  }, [open]);

  const handleEscape = (event: KeyboardEvent) => {
    const key = event.key;
    if (key === 'Escape') {
      setOpen(false);
      sendtrackEventOnClose();
    }
  };

  useEffect(() => {
    document.addEventListener('keyup', handleEscape);

    return () => document.removeEventListener('keyup', handleEscape);
  }, []);

  const sendtrackEventOnClose = () => {
    sendTrackingEvent([
      EVENTS.TAG,
      'video_play',
      {
        video_title: videoTitle,
        page_url: window.location.href,
        page_title: document.title,
        section_title: 'overview',
      },
    ]);
    sendTrackingEvent([EVENTS.GO]);
  };

  //@ts-ignore
  useClickOutside(containerRef, () => {
    if (open) {
      setOpen(false);
      sendtrackEventOnClose();
    }
  });

  return (
    <>
      {open && (
        <div className="video-player">
          <div className="video-player__container">
            <span className="video-player__close">
              <svg
                xmlns="http://www.w3.org/2000/svg"
                width="32"
                height="33"
                viewBox="0 0 32 33"
                fill="none"
              >
                <path
                  d="M16 15.3577L20.95 10.4077L22.364 11.8217L17.414 16.7717L22.364 21.7217L20.95 23.1357L16 18.1857L11.05 23.1357L9.63599 21.7217L14.586 16.7717L9.63599 11.8217L11.05 10.4077L16 15.3577Z"
                  fill="#06060E"
                />
              </svg>
            </span>
            <div ref={containerRef}>
              <AspectRatio
                width={1087}
                height={611}
                mobileWidth={390}
                mobileHeight={220}
              >
                <ReactPlayer
                  className="video-player__video"
                  url={url}
                  controls
                  width="100%"
                  height="100%"
                  playing
                />
              </AspectRatio>
            </div>
          </div>
        </div>
      )}
      {cloneElement(trigger, {
        onClick: () => {
          setOpen(true);
        },
      })}
    </>
  );
};

export default VideoPlayer;
