import { AdditionalButton, IModelsBanner } from './model/interface';

import './index.scss';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';
import AspectRatio from '@/shared/ui/AspectRatio/index';
import Button from '@/shared/ui/Button';
import VideoPlayer from './ui/VideoPlayer';
import StrapiButton from '@/shared/ui/StrapiButton';
import { getStrapiCdnUrl } from '@/app/lib/utils';

const ModelsBanner = ({
  title,
  subtitle,
  image,
  sectionId,
  playVideoButton,
  additionalTitle,
  additionalDescription,
  additionalButton,
  lang,
}: IModelsBanner) => {
  const button = (additionalButton: AdditionalButton) => {
    const { file, title, url, formUid, defaultFormValues } = additionalButton;

    let fileUrl = file.data?.attributes?.url;

    if (fileUrl) {
      fileUrl = `${getStrapiCdnUrl()}${fileUrl}`;
    }

    return (
      <StrapiButton
        className="models-banner__additional-button"
        button={{
          behavior: 'button',
          formUid: formUid,
          text: (
            <>
              <svg
                xmlns="http://www.w3.org/2000/svg"
                width="14"
                height="15"
                viewBox="0 0 14 15"
                fill="none"
              >
                <path
                  d="M0.493408 13.5H13.9934V15H0.493408V13.5ZM7.99341 9.129L12.5467 4.575L13.6072 5.6355L7.24341 12L0.879658 5.63625L1.94016 4.575L6.49341 9.1275V0.75H7.99341V9.129Z"
                  fill="white"
                />
              </svg>
              {title}
            </>
          ),
          download: !!fileUrl,
          url: fileUrl || url || '',
          appearance: 'dark',
          buttonSize: 'md',
          hasBorder: false,
          formDefaultValues: defaultFormValues,
        }}
        lang={lang}
      />
    );
  };

  return (
    <section className="models-banner" id={sectionId}>
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="models-banner__content">
              <h1 className="typo-head-2 models-banner__title">{title}</h1>
              <h2 className="typo-head-2 models-banner__subtitle">
                {subtitle}
              </h2>
              {playVideoButton?.url && (
                <VideoPlayer
                  url={playVideoButton.url}
                  videoTitle={playVideoButton.videoTitle}
                  trigger={
                    <Button
                      border
                      size="sm"
                      appearance="light"
                      className="models-banner__video-button"
                    >
                      <svg
                        xmlns="http://www.w3.org/2000/svg"
                        width="16"
                        height="17"
                        viewBox="0 0 16 17"
                        fill="none"
                      >
                        <path
                          fillRule="evenodd"
                          clipRule="evenodd"
                          d="M8 16.2721C12.4183 16.2721 16 12.6904 16 8.27209C16 3.85382 12.4183 0.272095 8 0.272095C3.58172 0.272095 0 3.85382 0 8.27209C0 12.6904 3.58172 16.2721 8 16.2721ZM6.24765 5.23729L11.5046 8.2724L6.24765 11.3075V5.23729Z"
                          fill="#1F1F1F"
                        />
                      </svg>
                      <span className="typo-link-sm">
                        {playVideoButton.text}
                      </span>
                    </Button>
                  }
                />
              )}
              <AspectRatio
                className="models-banner__image"
                width={345}
                height={206}
              >
                <StrapiImage img={image} />
              </AspectRatio>
            </div>
            {(additionalTitle || additionalDescription || additionalButton) && (
              <div className="models-banner__additional-content">
                <div className="models-banner__additional-text">
                  {additionalTitle && (
                    <span className="typo-body-1-m models-banner__additional-title">
                      {additionalTitle}
                    </span>
                  )}
                  {additionalDescription && (
                    <span className="typo-body-3 models-banner__additional-description">
                      {additionalDescription}
                    </span>
                  )}
                </div>
                {additionalButton && button(additionalButton)}
              </div>
            )}
          </div>
        </div>
      </div>
    </section>
  );
};

export default ModelsBanner;
