'use client';

import { useEffect, useState } from 'react';
import { Swiper, SwiperSlide } from 'swiper/react';
import { EffectFade, Thumbs } from 'swiper/modules';
import 'swiper/css';
import 'swiper/css/effect-fade';

import './index.scss';
import Button from '@/shared/ui/Button/index';
import { Models as IModels } from './model/interface';
import AspectRatio from '@/shared/ui/AspectRatio/index';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';
import cn from 'classnames';
import ClientButton from '@/shared/ui/ClientButton';
import { getPublicStrapiContent } from '@/app/lib/utils';
import Steps from '../Steps';

const Models = ({
  lang,
  models,
  sectionId,
  testDriveForm,
  translates,
}: IModels) => {
  const [thumbsSwiper, setThumbsSwiper] = useState(null);
  if (!models?.length) null;

  const [formData, setFormData] = useState(null);

  const getFormData = async () => {
    try {
      const form = await getPublicStrapiContent({
        url: `/api/form/find-by-uid/${testDriveForm}?locale=${lang}&populate=deep&publicationState=live`,
      });

      setFormData(form.data[0].attributes);
    } catch (e) {}
  };

  useEffect(() => {
    getFormData();
  }, []);

  return (
    <section className="models" id={sectionId}>
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="models__container">
              <Swiper
                initialSlide={1}
                className="models__slider"
                slidesPerView={1.24}
                spaceBetween={28}
                modules={[Thumbs]}
                centeredSlides={true}
                thumbs={{ swiper: thumbsSwiper }}
                breakpoints={{
                  1024: {
                    slidesPerView: 2,
                    spaceBetween: 104,
                  },
                }}
              >
                {models.map(({ img, name, slug, mobileImg }) => (
                  <SwiperSlide key={'img' + slug}>
                    <div className="model-card">
                      <AspectRatio
                        width={286}
                        height={206}
                        className="model-card__img"
                      >
                        <div
                          className={cn('model-card__img-container', {
                            'd-lg-none-down': !!mobileImg,
                          })}
                        >
                          <StrapiImage img={img} />
                        </div>

                        {mobileImg && (
                          <div className="model-card__img-container d-lg-none-up">
                            <StrapiImage img={mobileImg} />
                          </div>
                        )}
                      </AspectRatio>
                    </div>
                  </SwiperSlide>
                ))}
              </Swiper>

              <Swiper
                className="models__thumbs"
                onSwiper={(swiper: any) => setThumbsSwiper(swiper)}
                slidesPerView={1}
                effect={'fade'}
                modules={[EffectFade, Thumbs]}
                noSwipingClass={'models__thumbs'}
              >
                {models.map(({ name, title, description, slug, formValue }) => (
                  <SwiperSlide key={slug}>
                    <div className="model-card">
                      <div className="model-card__info">
                        <span className="model-card__name typo-eyebrow">
                          {name}
                        </span>
                        <span className="model-card__title typo-head-1">
                          {title}
                        </span>
                        <span className="model-card__description typo-body-1">
                          {description}
                        </span>
                      </div>
                      <div className="model-card__actions">
                        <Button
                          className="typo-link-big"
                          appearance="light"
                          size="lg"
                          href={`/${lang}/models/${slug}`}
                        >
                          {translates?.discover || 'Discover'}
                        </Button>
                        {formData && (
                          <ClientButton
                            trigger={
                              <Button
                                className="typo-link-big"
                                appearance="dark"
                                size="lg"
                              >
                                {translates?.testDrive || 'Test Drive'}
                              </Button>
                            }
                            render={
                              formData && (
                                <Steps
                                  data={formData}
                                  initFormValues={{ model: formValue || slug }}
                                />
                              )
                            }
                            instruction={'form'}
                            formUid={testDriveForm || ''}
                          />
                        )}
                      </div>
                    </div>
                  </SwiperSlide>
                ))}
              </Swiper>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default Models;
