import { DATA_SECTION_TITLE } from '@/app/lib/constants';
import StrapiButton from '@/shared/ui/StrapiButton';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';
import cn from 'classnames';
import './index.scss';

import { ModelBanner as IModelBanner } from './model/interface';

const ModelBanner = ({
  img,
  mobileImg,
  title,
  caption,
  sectionId,
  titleType: TitleTag,
  lang,
  buttons,
  internalSectionTitle,
}: IModelBanner) => {
  return (
    <section
      className="model-banner"
      id={sectionId}
      {...(internalSectionTitle
        ? { [DATA_SECTION_TITLE]: internalSectionTitle }
        : {})}
    >
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="model-banner__container">
              <div className="model-banner__text">
                {caption && (
                  <span className="model-banner__caption typo-eyebrow">
                    {caption}
                  </span>
                )}
                {title && (
                  <TitleTag className="model-banner__title">{title}</TitleTag>
                )}
              </div>
              <div className="model-banner__actions">
                {buttons?.map((button, index) => (
                  <StrapiButton key={index} button={button} lang={lang} />
                ))}
              </div>
            </div>
          </div>
        </div>
      </div>

      <div className="model-banner__img">
        <StrapiImage
          alt={title}
          img={img}
          className={cn({ 'd-lg-none-down': !!mobileImg })}
        />
        {mobileImg && (
          <StrapiImage alt={title} img={mobileImg} className="d-lg-none-up" />
        )}
      </div>
    </section>
  );
};

export default ModelBanner;
