import './index.scss';
import cn from 'classnames';
import { useEffect, useState, useRef } from 'react';
import { createPortal } from 'react-dom';
import useClickOutside from '@/app/lib/use-outside-click';

const Modal = ({ children, open, onClose, className }: any) => {
  const containerRef = useRef(null);
  const [show, setShow] = useState(false);

  useEffect(() => {
    setShow(open);

    ['html', 'body'].forEach((selector) => {
      const item = document.querySelector(selector) as HTMLElement;

      if (item) {
        if (open) {
          item.style.overflow = 'hidden';
          item.style.touchAction = 'none';
        } else {
          item.style.removeProperty('overflow');
          item.style.removeProperty('touch-action');
        }
      }
    });

    return () => {
      if (document?.querySelector('header')?.classList.contains('header_open'))
        return;
      ['html', 'body'].forEach((selector) => {
        const item = document.querySelector(selector) as HTMLElement;

        if (item) {
          item.style.removeProperty('overflow');
          item.style.removeProperty('touch-action');
        }
      });
    };
  }, [open]);

  const handleCloseModal = () => {
    setShow(false);
    onClose();
  };

  //@ts-ignore
  useClickOutside(containerRef, () => {
    if (show) {
      handleCloseModal();
    }
  });

  return createPortal(
    <div className={cn('modal', className, { modal_show: show })}>
      <div className="modal__container" ref={containerRef}>
        <button className="modal__close" onClick={handleCloseModal}>
          <svg
            xmlns="http://www.w3.org/2000/svg"
            width="14"
            height="14"
            viewBox="0 0 14 14"
            fill="none"
          >
            <path
              d="M6.99999 5.52471L11.95 0.574707L13.364 1.98871L8.41399 6.93871L13.364 11.8887L11.95 13.3027L6.99999 8.35271L2.04999 13.3027L0.635986 11.8887L5.58599 6.93871L0.635986 1.98871L2.04999 0.574707L6.99999 5.52471Z"
              fill="#B7B7B7"
            />
          </svg>
        </button>
        <div className="modal__content">{children}</div>
      </div>
    </div>,
    document.body,
  );
};

export default Modal;
