import { StrapiImageInterface } from '@/shared/ui/StrapiImage';

export interface Link {
  content: string;
  title: string;
  type: 'link' | 'email' | 'tel';
}

export interface Button extends Link {
  formDefaultValues?: any;
  formUid?: string;
  hiddenFormFields?: any;
  mobileStyles?: string;
  desktopStyles?: string;
  id: number;
}

export interface Card {
  id: number;
  title: string;
  subtitle: string;
  description: string;
  info: Link[];
  button: Button[];
}

export interface LocationCard extends Card {
  el: React.ReactNode;
}

export interface Banner {
  data?: { attributes: StrapiImageInterface };
}

export interface LocationProps<T = Card> {
  lang: string;
  banner?: Banner;
  title: string;
  description: string;
  cityFilterPlaceholder: string;
  tabs: {
    id: number;
    title: string;
    card: T[];
  }[];
}
