import { Arrow } from '@icons';
import ArrowLink from '@/shared/ui/ArrowLink';
import StrapiButton from '@/shared/ui/StrapiButton';
import { Content } from './components';
import './index.scss';
import { Link, LocationProps } from './types';
import React from 'react';

const makeLinkByType = ({ type, content }: Pick<Link, 'content' | 'type'>) => {
  switch (type) {
    case 'email':
      return `mailto:${content}`;
    case 'tel':
      return `tel:${content}`;
    default:
      return content;
  }
};

const Locations = (props: LocationProps) => {
  const tabs = props.tabs.map(({ card, id, title }) => {
    return {
      id,
      title,
      card: card.map((cardData) => {
        const { id, button, description, info, subtitle, title } = cardData;
        return {
          ...cardData,
          el: (
            <div key={id} className="location-card">
              <div className="location-card__container">
                <div className="location-card__header">
                  {subtitle && (
                    <span className="location-card__subtitle typo-body-2-m">
                      {subtitle}
                    </span>
                  )}
                  {title && (
                    <span className="location-card__title typo-head-4">
                      {title}
                    </span>
                  )}
                </div>
                {(description || !!info?.length) && (
                  <div className="location-card__content">
                    {description && (
                      <span className="location-card__description typo-body-2-b">
                        {description}
                      </span>
                    )}
                    {!!info?.length && (
                      <div className="location-card__info">
                        {info.map(({ content, title, type }, index) => {
                          return (
                            <span key={index}>
                              {title}{' '}
                              <a
                                href={makeLinkByType({
                                  type,
                                  content,
                                })}
                                {...(type === 'link'
                                  ? { target: '_blank' }
                                  : {})}
                              >
                                {content}
                              </a>
                            </span>
                          );
                        })}
                      </div>
                    )}
                  </div>
                )}
                {!!button?.length && (
                  <div className="location-card__buttons">
                    {button.map(
                      ({
                        content,
                        title,
                        type,
                        formUid,
                        formDefaultValues,
                        hiddenFormFields,
                        mobileStyles,
                        desktopStyles,
                        id,
                      }) => {
                        const dynamicClassName = `locationbutton${id}`;

                        return (
                          <React.Fragment key={dynamicClassName}>
                            {desktopStyles && (
                              <style
                                dangerouslySetInnerHTML={{
                                  __html: `@media (min-width: 1024.01px){
                                  .${dynamicClassName}{
                                    ${desktopStyles}
                                  }
                                }`,
                                }}
                              ></style>
                            )}
                            {mobileStyles && (
                              <style
                                dangerouslySetInnerHTML={{
                                  __html: `@media (max-width: 1024px){
                                  .${dynamicClassName}{
                                    ${mobileStyles}
                                  }
                                }`,
                                }}
                              ></style>
                            )}
                            {formUid ? (
                              <StrapiButton
                                className={dynamicClassName}
                                //@ts-ignore
                                button={{
                                  behavior: 'link',
                                  formUid,
                                  text: (
                                    <>
                                      {title}
                                      {Arrow}
                                    </>
                                  ),
                                  url: content,
                                  formDefaultValues,
                                  hiddenFormFields,
                                }}
                                lang={props.lang}
                              />
                            ) : (
                              <ArrowLink
                                className={dynamicClassName}
                                href={makeLinkByType({ type, content })}
                                {...(type === 'link'
                                  ? { target: '_blank' }
                                  : {})}
                              >
                                {title}
                              </ArrowLink>
                            )}
                          </React.Fragment>
                        );
                      },
                    )}
                  </div>
                )}
              </div>
            </div>
          ),
        };
      }),
    };
  });

  return (
    <section className="locations">
      <div className="container">
        <div className="row">
          <div className="col-12">
            {tabs.length && <Content {...props} tabs={tabs} />}
          </div>
        </div>
      </div>
    </section>
  );
};

export default Locations;
