'use client';
import Select from '@/shared/ui/Select';
import { useEffect, useState } from 'react';
import './index.scss';

function getNormalizedSubtitles(data: any, cityFilterPlaceholder: string) {
  const result = {
    all: { value: 'all', text: cityFilterPlaceholder, ids: [] },
  };

  data.forEach((section: any) => {
    if (section.card && Array.isArray(section.card)) {
      section.card.forEach((card: any) => {
        const rawSubtitle = (card.subtitle || '').trim();
        const normalized = rawSubtitle.toLowerCase();

        //@ts-ignore
        if (!result[normalized]) {
          //@ts-ignore
          result[normalized] = {
            value: normalized,
            text: rawSubtitle,
            ids: [],
          };
        }
        //@ts-ignore
        result[normalized].ids.push(card.id);
        //@ts-ignore
        result.all.ids.push(card.id);
      });
    }
  });

  return result;
}

const Header = ({
  title,
  description,
  cityFilterPlaceholder,
  tabs,
  onCityChange,
}: any) => {
  const cities = {
    ...getNormalizedSubtitles(tabs, cityFilterPlaceholder),
  };
  const [activeOption, setActiveOption] = useState(cities.all);

  useEffect(() => {
    onCityChange(activeOption.ids);
  }, [activeOption]);

  return (
    <div className="locations-header">
      <div className="locations-header__container">
        <div className="locations-header__text">
          {title && (
            <h1 className="typo-head-2 locations-header__title">{title}</h1>
          )}
          {description && (
            <p className="typo-body-2 locations-header__description d-lg-none-up">
              {description}
            </p>
          )}
        </div>

        {cityFilterPlaceholder && (
          <div className="locations-header__select">
            <Select
              key={'cities'}
              name={'cities'}
              hideDefaultPlaceholder
              placeholder={cityFilterPlaceholder}
              value={activeOption}
              options={Object.values(cities)}
              onChange={(value: string) => {
                //@ts-ignore
                setActiveOption(cities[value]);
              }}
            />
          </div>
        )}
      </div>
    </div>
  );
};

export default Header;
