import cn from 'classnames';
import './index.scss';

interface Card {
  id: number;
}

interface Props {
  activeTab: number;
  tabs: { id: number; title: string; card: Card[] }[];
  showedIds: number[];
  onTabChange: (index: number) => void;
}

const Tabs = ({ activeTab, tabs, onTabChange, showedIds }: Props) => {
  return (
    <div className="locations-tabs">
      <div
        className="locations-tabs__container"
        style={{ gridTemplateColumns: `repeat(${tabs.length}, 1fr)` }}
      >
        {tabs.map(({ id, title, card }, index) => (
          <div
            key={id}
            onClick={() => onTabChange(index)}
            className={cn('location-tab', 'typo-body-1-m', {
              'location-tab_active': activeTab === index,
            })}
          >
            {title} ({card.filter(({ id }) => showedIds.includes(id)).length})
          </div>
        ))}
      </div>
    </div>
  );
};

export default Tabs;
