import { LocationCard } from '../../../../types';
import cn from 'classnames';
import { ReactNode, Fragment } from 'react';

import './index.scss';

interface Props {
  activeTab: number;
  showedIds: number[];
  lang: string;
  tabs: {
    id: number;
    title: string;
    card: LocationCard[];
  }[];
}

const Cards = ({ activeTab, tabs, showedIds }: Props) => {
  return (
    <div className="locations-cards">
      <div className="locations-cards__container">
        {tabs.map(({ card }, index) => {
          return (
            <div
              key={index}
              className={cn('cards', { cards_active: index === activeTab })}
            >
              {card
                .filter(({ id }) => showedIds.includes(id))
                .map(({ el }, index) => {
                  return <Fragment key={index}>{el}</Fragment>;
                })}
            </div>
          );
        })}
      </div>
    </div>
  );
};

export default Cards;
