'use client';
import { useState } from 'react';
import { LocationCard, LocationProps } from '../../types';
import Header from '../Header';
import './index.scss';
import Cards from './ui/Cards';
import Tabs from './ui/Tabs';

const Content = ({
  tabs,
  title,
  description,
  cityFilterPlaceholder,
  lang,
}: LocationProps<LocationCard>) => {
  const [activeTab, setActiveTab] = useState(0);
  const [showedIds, setShowedIds] = useState([]);

  const handleTabChange = (index: number) => {
    if (activeTab !== index) {
      setActiveTab(index);
    }
  };

  return (
    <>
      <Header
        title={title}
        description={description}
        cityFilterPlaceholder={cityFilterPlaceholder}
        tabs={tabs}
        onCityChange={setShowedIds}
      />
      <Tabs
        tabs={tabs}
        activeTab={activeTab}
        onTabChange={handleTabChange}
        showedIds={showedIds}
      />
      <Cards
        tabs={tabs}
        activeTab={activeTab}
        showedIds={showedIds}
        lang={lang}
      />
    </>
  );
};

export default Content;
