import { PinIcon } from '@/app/assets/icons';
import './index.scss';
import { useParams } from 'next/navigation';

const translates = {
  ar: {
    title: 'يُرجى السماح بالوصول لموقعك الحالي',
    description:
      'لمساعدتك في العثور على أقرب معرض، يُرجى السماح بالوصول إلى موقعك الحالي من خلال تفعيل خدمات الموقع.',
  },
  en: {
    title: 'Location Access Needed',
    description:
      'To help you find the nearest store, we need access to your current location. Please enable location services.',
  },
};

const LocationModal = () => {
  const params = useParams();
  //@ts-ignore
  const translate = translates[params?.lang] || translates.en;

  return (
    <div className="location-modal">
      <div className="location-modal__container">
        <div className="location-modal__icon">{PinIcon}</div>
        <div className="location-modal__text">
          <span className="location-modal__title typo-head-4">
            {translate.title}
          </span>
          <p className="location-modal__description typo-body-2">
            {translate.description}
          </p>
        </div>
      </div>
    </div>
  );
};

export default LocationModal;
