'use client';

import { useRef, useState } from 'react';

import { Swiper, SwiperSlide } from 'swiper/react';
import { Navigation } from 'swiper/modules';

import Slide from '../Slide';

import type { Swiper as SwiperType } from 'swiper';
import { ISlide } from '../../model/interface';

import './index.scss';

const Slider = ({ slides }: { slides: ISlide[] }) => {
  const nextElRef = useRef<HTMLDivElement>(null);
  const prevElRef = useRef<HTMLDivElement>(null);
  const [swiper, setSwiper] = useState<SwiperType | null>(null);

  const navIcon = (
    <svg
      width="32"
      height="33"
      viewBox="0 0 32 33"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      className="image-with-carousel-slider__navigation-icon"
    >
      <rect y="0.461914" width="32" height="32" rx="16" fill="#333333" />
      <path
        d="M17.172 16.4621L12.222 11.5121L13.636 10.0981L20 16.4621L13.636 22.8261L12.222 21.4121L17.172 16.4621Z"
        fill="white"
      />
    </svg>
  );

  return (
    <>
      <div className="image-with-carousel-slider">
        <Swiper
          modules={[Navigation]}
          spaceBetween={24}
          slidesPerView={1.27}
          onSwiper={setSwiper}
          breakpoints={{
            1024: {
              slidesPerView: 2.64,
              slideToClickedSlide: true,
            },
          }}
          navigation={{
            nextEl: nextElRef.current,
            prevEl: prevElRef.current,
            disabledClass:
              'image-with-carousel-slider__navigation-item_disabled',
          }}
        >
          {slides?.map(({ img, title, description }, index) => (
            <SwiperSlide key={index}>
              <Slide img={img} title={title} description={description} />
            </SwiperSlide>
          ))}
        </Swiper>
        <div className="image-with-carousel-slider__navigation">
          <div
            ref={prevElRef}
            className="image-with-carousel-slider__navigation-item image-with-carousel-slider__navigation-item_prev"
          >
            {navIcon}
          </div>
          <div
            ref={nextElRef}
            className="image-with-carousel-slider__navigation-item image-with-carousel-slider__navigation-item_next"
          >
            {navIcon}
          </div>
        </div>
      </div>
    </>
  );
};

export default Slider;
