import { StrapiImage } from '@/shared/ui/StrapiImage/index';

import { ISlide } from '../../model/interface';

import './index.scss';

const MainSlide = ({ img, title, description }: ISlide) => {
  return (
    <div className="image-with-carousel-slide">
      <StrapiImage className="image-with-carousel-slide__image" img={img} />
      <h3 className="typo-head-4 image-with-carousel-slide__title">{title}</h3>
      <p className="typo-body-2 image-with-carousel-slide__description">
        {description}
      </p>
    </div>
  );
};

export default MainSlide;
