import { IThumbnailsSlider } from './model/interface';

import './index.scss';
import Slider from './ui/Slider';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';
import AspectRatio from '@/shared/ui/AspectRatio/index';

const ImageWithSlider = ({
  title,
  subtitle,
  image,
  slides,
  sectionId,
}: IThumbnailsSlider) => {
  return (
    <section className="image-with-carousel" id={sectionId}>
      <div className="container">
        <div className="row">
          <div className="col-12">
            {subtitle && (
              <span className="typo-eyebrow image-with-carousel__subtitle">
                {subtitle}
              </span>
            )}
            <h2 className="typo-head-2 image-with-carousel__title">{title}</h2>
            {image && (
              <AspectRatio
                width={1280}
                height={562}
                mobileHeight={342}
                mobileWidth={385}
                className="image-with-carousel__image"
              >
                <StrapiImage img={image} />
              </AspectRatio>
            )}
            <Slider slides={slides} />
          </div>
        </div>
      </div>
    </section>
  );
};

export default ImageWithSlider;
