import './index.scss';
import { Cross, Loupe } from '@icons';

import { Search as ISearch } from '../../model/interface';
import { useEffect, useState, useRef } from 'react';
import cn from 'classnames';
import { useParams } from 'next/navigation';
import { useRouter } from 'next/navigation';

const Search = ({ translates, className, onSearchClose }: ISearch) => {
  const params = useParams();
  const router = useRouter();

  const [inputValue, setInputValue] = useState('');
  const inputRef = useRef<HTMLInputElement>(null);

  const handleAction = () => {
    if (inputValue) {
      router.push(`/${params!.lang}/results?q=${inputValue}`);
      onSearchClose();
    } else {
      onSearchClose();
    }
  };

  useEffect(() => {
    inputRef.current?.focus();
  }, [inputRef.current]);

  return (
    <div className={cn('search', className)}>
      <div className="search__container">
        <input
          ref={inputRef}
          type="text"
          placeholder={translates?.searchPlaceholder || 'Start searching...'}
          className="search__input typo-head-5"
          onChange={(e) => setInputValue(e.target.value)}
          value={inputValue}
          onKeyUp={(e) => e.keyCode === 13 && inputValue && handleAction()}
        />
        <div
          className={cn('search__actions', { 'has-value': !!inputValue })}
          onClick={handleAction}
        >
          <div className="cross">{Cross}</div>
          <div className="loupe">{Loupe}</div>
        </div>
      </div>
    </div>
  );
};

export default Search;
