import './index.scss';
import Link from 'next/link';
import { ModelsList as IModelsList } from '../../model/interface';
import cn from 'classnames';
import AspectRatio from '@/shared/ui/AspectRatio/index';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';

const ModelsList = ({ lang, className, models, translates }: IModelsList) => {
  return (
    <div className={cn('header-models-list', className)}>
      <div className="header-models-list__container">
        {models.map(({ img, productName: name, slug }) => (
          <div className="model" key={name}>
            <div className="model__container">
              <AspectRatio
                className="model__img"
                width={179}
                height={104}
                mobileWidth={123}
                mobileHeight={72}
              >
                <StrapiImage img={img} />
              </AspectRatio>

              <div className="model__content">
                <span className="model__name typo-head-5">{name}</span>
                <div className="model__links">
                  <Link
                    href={`/${lang}/models/${slug}`}
                    className="typo-link-2"
                  >
                    {translates?.discover || 'Discover'}
                  </Link>
                  {/* <Link href={`/${lang}/order/${slug}`} className="typo-link-2">
                    {translates?.order || 'Order'}
                  </Link> */}
                </div>
              </div>
            </div>
          </div>
        ))}
      </div>
    </div>
  );
};

export default ModelsList;
