import './index.scss';
import { Language as ILanguage } from '../../model/interface';
import Link from 'next/link';
import { useEffect, useState } from 'react';
import { Globe } from '@/app/assets/icons';

const MobileLanguage = ({
  className,
  languages,
  defaultLanguage,
}: ILanguage) => {
  const [currentNewPage, setCurrentNewPage] = useState('');
  const [nextLang, setNextLang] = useState('');

  useEffect(() => {
    const targetLang = languages.find(
      (lang) => lang !== defaultLanguage,
    ) as string;
    setNextLang(targetLang);

    setCurrentNewPage(
      window.location.href.replace(defaultLanguage, targetLang),
    );
  }, []);

  return (
    <Link href={currentNewPage} className={`mobile-lang ${className || ''}`}>
      <div className="mobile-lang__icon">{Globe}</div>
      <span className="typo-body-1">{nextLang}</span>
    </Link>
  );
};

export default MobileLanguage;
