import { getPublicStrapiContent } from '@/app/lib/utils';
import { StrapiImageInterface } from '@/shared/ui/StrapiImage';
import CtaButtons from '@/widgets/CtaButtons';
import { memo, useEffect, useState } from 'react';

const MobileCtaButtons = memo(
  ({
    lang,
    navigation,
    className,
  }: {
    className: string;
    lang: string;
    navigation: {
      href: string;
      rawIcon: string;
      title: string;
      formUid?: string;
    }[];
  }) => {
    const [links, setLinks] = useState<any>([]);

    useEffect(() => {
      Promise.all(
        navigation.map(async ({ href: url, rawIcon, title, formUid }) => {
          const params: any = {
            logo: rawIcon,
            title,
            url: url || '',
            formUid,
          };

          if (formUid) {
            try {
              const form = await getPublicStrapiContent({
                url: `/api/form/find-by-uid/${formUid}?locale=${lang}&populate=deep&publicationState=live`,
              });

              params.formData = form.data[0].attributes;
            } catch (e) {}
          }

          return params;
        }),
      ).then(setLinks);
    }, []);

    return <CtaButtons className={className} links={links} />;
  },
);
MobileCtaButtons.displayName = 'MobileCtaButtons';
export default MobileCtaButtons;
