import './index.scss';
import { Language as ILanguage } from '../../model/interface';
import Link from 'next/link';
import { useEffect, useState } from 'react';

const Language = ({ className, languages, defaultLanguage }: ILanguage) => {
  const [currentNewPage, setCurrentNewPage] = useState('');
  const [nextLang, setNextLang] = useState('');

  useEffect(() => {
    const targetLang = languages.find(
      (lang) => lang !== defaultLanguage,
    ) as string;
    setNextLang(targetLang);

    setCurrentNewPage(
      window.location.href.replace(defaultLanguage, targetLang),
    );
  }, []);

  return (
    <div className={`lang ${className || ''}`}>
      <div className="lang__container">
        <Link href={currentNewPage} className="lang__value typo-body-1-m">
          {nextLang}
        </Link>
      </div>
    </div>
  );
};

export default Language;
