import { TransparentPinIcon } from '@/app/assets/icons';
import ClientButton from '@/shared/ui/ClientButton';
import './index.scss';

const FindDealer = ({ text }: { text: string }) => {
  return (
    <ClientButton
      trigger={
        <div className="find-dealer header__menu-item">
          <div className="find-dealer__icon">{TransparentPinIcon}</div>
          <span className="find-dealer__text typo-body-1-m">
            {text || 'Find a dealer'}
          </span>
        </div>
      }
      instruction={'location'}
      formUid=""
    ></ClientButton>
  );
};

export default FindDealer;
