import { useEffect, useState } from 'react';
import cn from 'classnames';
import './index.scss';
import { Burger as IBurger } from '../../model/interface';

const Burger = ({ onBurgerClick, open }: IBurger) => {
  const [isActive, setIsActive] = useState(false);

  const handleBurgerClick = () => {
    const val = !isActive;
    setIsActive(val);
    onBurgerClick(val);
  };

  useEffect(() => {
    setIsActive(open);
  }, [open]);

  return (
    <div
      className={cn('burger', { burger_active: isActive })}
      onClick={handleBurgerClick}
    >
      <div className="burger__container">
        <span></span>
        <span></span>
        <span></span>
      </div>
    </div>
  );
};

export default Burger;
