import { StrapiImageInterface } from '@/shared/ui/StrapiImage/index';

export interface Header {
  type?: 'dark' | 'light' | 'transparent';
  lang: string;
  locales: string[];
  offerTypeLayout?: boolean;
  eventTypeLayout?: boolean;
  data: {
    cta: {
      hasBorder: boolean;
      navigation: {
        title: string;
        href: string;
        rawIcon: string;
      }[];
    };
    navigation: {
      title: string;
      url: string;
      hideInMobile: boolean;
      hideInDesktop: boolean;
    }[];
  };
  models: {
    slug: string;
    img: StrapiImageInterface;
    name: string;
    title: string;
    description: string;
    productName: string;
  }[];
  hideHeaderOnScroll?: boolean;
  translates: { [key: string]: string };
}

export interface Language {
  languages: string[];
  defaultLanguage: string;
  className?: string;
}

export interface Burger {
  open: boolean;
  onBurgerClick: (state: boolean) => void;
}

export interface Search {
  className?: string;
  translates: any;
  onSearchClose: () => void;
}

export interface Model {
  slug: string;
  img: StrapiImageInterface;
  name: string;
  title: string;
  description: string;
  productName: string;
}

export interface ModelsList {
  className?: string;
  models: Model[];
  lang: string;
  translates: { [key: string]: string };
}

export interface Article {
  data: string;
  title: string;
  img: StrapiImageInterface;
  url: string;
}

export interface SearchResults {
  className?: string;
  title: string;
  models: Model[];
  articles?: Article[];
  lang: string;
}
