import './index.scss';
import NextLink from 'next/link';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';
import { Footer as IFooter } from './model/interface';
import RichText from '@/shared/ui/RichText/index';

const Footer = ({ data, lang }: { lang: string; data: IFooter }) => (
  <footer className="footer">
    <div className="container">
      <div className="row">
        <div className="col-12">
          <div className="footer__container">
            <div className="footer__top">
              <div className="footer__logo">
                <StrapiImage img={data.logo?.data?.attributes} />
              </div>
              <div className="footer__description typo-body-2">
                <RichText text={data.description} />
              </div>
              <div className="footer__socials">
                {data.socials.map(({ rawIcon, href }, index) => (
                  <NextLink
                    key={`sc${index}`}
                    className="social-item"
                    href={href}
                    target="_blank"
                    dangerouslySetInnerHTML={{ __html: rawIcon }}
                  />
                ))}
              </div>
              <div className="footer__company">
                <StrapiImage img={data.company?.data?.attributes} />
              </div>
            </div>
            <div className="footer__menu">
              {data.menus.map(({ items, title }, index) => (
                <div className="footer-menu-item" key={`fm${index}`}>
                  <span className="footer-menu-item__title typo-body-1-m">
                    {title}
                  </span>
                  <div className="footer-menu-item__content">
                    {items.map(({ title, url }, childIndex) => (
                      <NextLink
                        href={`/${lang}/${url}`}
                        className="typo-body-1-m footer-menu-item__link"
                        key={`fm${index}fmc${childIndex}`}
                      >
                        {title}
                      </NextLink>
                    ))}
                  </div>
                </div>
              ))}
            </div>
            <div className="footer__bottom">
              <div className="footer__bottom-links">
                {data.legal.map(({ title, url }, index) => (
                  <NextLink
                    key={`ll${index}`}
                    href={`/${lang}/${url}`}
                    className="typo-body-2"
                  >
                    {title}
                  </NextLink>
                ))}
              </div>
              <p className="footer__caption typo-body-2">{data.copyright}</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </footer>
);

export default Footer;
