import './index.scss';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';
import { OfferCard as IOfferCard } from '../../model/interface';
import AspectRatio from '@/shared/ui/AspectRatio';
import Link from 'next/link';

const OfferCard = ({ lang, offer, banner, mobileBanner }: IOfferCard) => {
  if (!offer.data) return null;
  return (
    <div className="offer-card">
      <Link
        className="offer-card__img"
        href={`${lang}/offers/${offer.data.attributes.slug}`}
      >
        <AspectRatio
          width={banner.data.attributes.width}
          height={banner.data.attributes.height}
          mobileWidth={mobileBanner.data?.attributes.width}
          mobileHeight={mobileBanner.data?.attributes.height}
        >
          <StrapiImage
            img={banner.data.attributes}
            className="d-lg-none-down"
          />

          {mobileBanner.data?.attributes && (
            <StrapiImage
              img={mobileBanner.data.attributes}
              className="d-lg-none-up"
            />
          )}
        </AspectRatio>
      </Link>
    </div>
  );
};

export default OfferCard;
