import { CtaCard as ICtaCard } from '../../model/interface';
import './index.scss';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';
import AspectRatio from '@/shared/ui/AspectRatio/index';
import StrapiButton from '@/shared/ui/StrapiButton';
import cn from 'classnames';
import { DATA_SECTION_TITLE } from '@/app/lib/constants';

const CtaCard = ({
  banner,
  mobileImage,
  description,
  button,
  title,
  lang,
  internalSectionTitle,
  additionalStyle,
}: ICtaCard) => {
  const mobileImg = mobileImage?.data?.attributes;
  return (
    <section
      className="cta-section-card"
      {...(internalSectionTitle
        ? { [DATA_SECTION_TITLE]: internalSectionTitle }
        : {})}
      {...(additionalStyle ? { style: additionalStyle } : {})}
    >
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="subscribe-card">
              <div className="subscribe-card__container">
                <div className="subscribe-card__text">
                  <span className="subscribe-card__title typo-head-2">
                    {title}
                  </span>
                  <p className="subscribe-card__description typo-body-1">
                    {description}
                  </p>
                  <>
                    {button && (
                      <StrapiButton
                        className="subscribe-card__action "
                        button={button}
                        lang={lang}
                      />
                    )}
                  </>
                </div>
                <AspectRatio
                  className="subscribe-card__img"
                  width={791}
                  height={600}
                  mobileWidth={342}
                  mobileHeight={310}
                >
                  <StrapiImage
                    alt={title}
                    img={banner.data.attributes}
                    className={cn({ 'd-lg-none-down': !!mobileImg })}
                  />
                  {mobileImg && (
                    <StrapiImage img={mobileImg} className="d-lg-none-up" />
                  )}
                </AspectRatio>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default CtaCard;
