import './index.scss';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';
import { ActionCard as IActionCard } from '../../model/interface';
import StrapiButton from '@/shared/ui/StrapiButton';

const ActionCard = ({ icon, rawIcon, title, button, lang }: IActionCard) => {
  const content = !rawIcon ? (
    <div className="action-card__icon">
      <StrapiImage img={icon.data.attributes} />
    </div>
  ) : (
    <div
      className="action-card__icon"
      dangerouslySetInnerHTML={{ __html: rawIcon }}
    />
  );
  return (
    <div className="action-card" key={title}>
      <div className="action-card__container">
        {content}
        <div className="action-card__text">
          <span className="action-card__title typo-head-2">{title}</span>
          <>{button && <StrapiButton button={button} lang={lang} />}</>
        </div>
      </div>
    </div>
  );
};

export default ActionCard;
