import { StrapiButton } from '@/shared/ui/StrapiButton/model/interface';
import { StrapiImageInterface } from '@/shared/ui/StrapiImage/index';

export interface CtaCard {
  title: string;
  description: string;
  mobileImage: { data: { attributes: StrapiImageInterface } };
  banner: { data: { attributes: StrapiImageInterface } };
  button: StrapiButton;
  formData?: any;
  reservedAction: '' | 'location' | 'form';
  lang: string;
  internalSectionTitle?: string;
  additionalStyle: any;
}

export interface ActionCard {
  icon: { data: { attributes: StrapiImageInterface } };
  rawIcon: string;
  title: string;
  button: StrapiButton;
  formUid: string;
  formData?: any;
  reservedAction: '' | 'location' | 'form';
  lang: string;
}

export interface OfferCard {
  offer: any;
  lang: string;
  banner: { data: { attributes: StrapiImageInterface } };
  mobileBanner: { data: { attributes: StrapiImageInterface } };
}
export interface DealerCta {
  ctacards: ActionCard[];
  offercards: OfferCard[];
  ctacard: CtaCard;
  internalSectionTitle?: string;
}
