import { DealerCta as IDealerCta } from './model/interface';
import './index.scss';
import cn from 'classnames';
import ActionCard from './ui/ActionCard';
import OfferCard from './ui/OfferCard';
import CtaCard from './ui/CtaCard';
import { DATA_SECTION_TITLE } from '@/app/lib/constants';

const DealerCta = ({ data, lang }: { data: IDealerCta; lang: string }) => {
  const { internalSectionTitle, ctacard, ctacards, offercards } = data;

  return (
    <>
      <section
        className="dealer-cta"
        {...(internalSectionTitle
          ? { [DATA_SECTION_TITLE]: internalSectionTitle }
          : {})}
      >
        <div className="container">
          <div className="row">
            <div className="col-12">
              <div className="dealer-cta__container">
                {ctacards?.length && (
                  <div
                    className={cn('dealer-cta__action-cards', {
                      'dealer-cta__action-cards_single': ctacards.length === 1,
                    })}
                  >
                    {ctacards.map((card) => {
                      return (
                        <ActionCard key={card.title} {...card} lang={lang} />
                      );
                    })}
                  </div>
                )}
                <>
                  {offercards?.map((card) => (
                    <OfferCard
                      key={new Date().toString()}
                      {...card}
                      lang={lang}
                    />
                  ))}
                </>
              </div>
            </div>
          </div>
        </div>
      </section>
      {ctacard && (
        <CtaCard
          {...ctacard}
          lang={lang}
          additionalStyle={{ paddingBottom: '25px' }}
        />
      )}
    </>
  );
};

export default DealerCta;
