import ArrowLink from '@/shared/ui/ArrowLink';

import { ICtaCard } from '../../model/interface';

import './index.scss';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';
import AspectRatio from '@/shared/ui/AspectRatio/index';
import StrapiButton from '@/shared/ui/StrapiButton';

const CtaCard = ({ image, title, description, links, lang }: ICtaCard) => {
  return (
    <div className="cta-card">
      <AspectRatio width={342} height={200} className="cta-card__image">
        {image && <StrapiImage img={image} />}
      </AspectRatio>

      <h3 className="cta-card__title typo-head-3">{title}</h3>
      <p className="cta-card__description typo-body-1">{description}</p>
      <div className="cta-card__links">
        {links?.map((link) => (
          <StrapiButton
            key={link.label}
            className="cta-card__link typo-link-big"
            button={{
              behavior: 'link',
              formUid: link.formUid,
              text: link.label,
              download: link?.download,
              url: link?.href || '',
              appearance: 'transparent',
              buttonSize: 'sm',
              hasBorder: false,
              formDefaultValues: link?.defaultFormValues,
            }}
            lang={lang}
          />
        ))}
      </div>
    </div>
  );
};

export default CtaCard;
