import CtaCard from './ui/CtaCard';

import { ICtaGroup } from './model/interface';

import './index.scss';
import { DATA_SECTION_TITLE } from '@/app/lib/constants';

const CtaGroup = ({
  cards,
  sectionId,
  lang,
  internalSectionTitle,
}: ICtaGroup) => {
  return (
    <section
      className="cta-group"
      id={sectionId}
      {...(internalSectionTitle
        ? { [DATA_SECTION_TITLE]: internalSectionTitle }
        : {})}
    >
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="cta-group__cards">
              {cards.map((card, index) => (
                <CtaCard key={index} {...card} lang={lang} />
              ))}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default CtaGroup;
