import Link from 'next/link';
import cn from 'classnames';

import { Buttons } from './model/interface';

import './index.scss';
import ClientButton from '@/shared/ui/ClientButton/index';
import Steps from '../Steps';

const CtaButtons = ({ className, border, links }: Buttons) => {
  return (
    <div
      className={cn('cta-buttons', className, { 'cta-buttons_border': border })}
    >
      <div className="cta-buttons__container">
        {links?.map(({ logo, title, url, formData, formUid }) => {
          const isLocation = url === 'location';
          return (
            <ClientButton
              key={url}
              trigger={
                <Link href={url ?? ''} className="cta-button">
                  <div className="cta-button__container">
                    <div
                      className="cta-button__icon"
                      dangerouslySetInnerHTML={{ __html: logo }}
                    ></div>
                    <span className="cta-button__title typo-body-2">
                      {title}
                    </span>
                  </div>
                </Link>
              }
              instruction={isLocation ? 'location' : formData && 'form'}
              render={formData && <Steps data={formData} />}
              formUid={formUid}
            />
          );
        })}
      </div>
    </div>
  );
};

export default CtaButtons;
